/*
 * Structures and definitions for dealing with switch enclosures
 */
#include <pthread.h>

struct fms_switch {
  struct lf_event *switch_query_done_task;
  struct lf_event *switch_start_query_timer;

  /* pthread synchronization stuff */
  pthread_cond_t switch_cond;
  pthread_mutex_t switch_mutex;

  int num_switch_monitors;		/* number of active monitors */
  int switch_queries_pending;		/* # of queries currently in progress */


  /* some vars for fabric resolution */
  void (*res_handler)(void);
  void (*res_deferred_handler)(void);
};

/*
 * prototypes
 */
void fms_switch_set_res_handler(void (*handler)(void));
void fms_switch_clear_res_handler(void);
void fms_switch_alert_xbarport_disabled(struct lf_xbar *xbp, int port);
void fms_switch_alert_xbarport_enabled(struct lf_xbar *xbp, int port);
void fms_switch_alert_xbarport_down(struct lf_xbar *xbp, int port);
void fms_switch_alert_xbarport_up(struct lf_xbar *xbp, int port);
void fms_switch_alert_xcvr_disabled(struct lf_xcvr *xcp);
void fms_switch_alert_xcvr_enabled(struct lf_xcvr *xcp);
void fms_switch_alert_xcvr_signal_lost(struct lf_xcvr *xcp);
void fms_switch_alert_xcvr_signal_ok(struct lf_xcvr *xcp);
void fms_switch_alert_enclosure_read_ok(struct lf_enclosure *ep);
void fms_switch_alert_cannot_read_enclosure(struct lf_enclosure *ep);
void fms_switch_alert_xbar_link_down(struct lf_xbar *xp, int port);
void fms_switch_alert_xbar_link_up(struct lf_xbar *xp, int port);
void fms_switch_alert_link_up(struct fms_link *linkp);
void fms_switch_alert_xbar_int_link_down(struct lf_xbar *xp, int port);
void fms_switch_alert_xbar_ext_link_down(struct lf_xbar *xp, int port);
void fms_switch_alert_xbar_host_link_down(struct lf_xbar *xp, int port);
void fms_switch_alert_linecard_hot(struct lf_linecard *lp);
void fms_switch_alert_linecard_cool(struct lf_linecard *lp);
void fms_switch_alert_linecard_overtemp(struct lf_linecard *lp);
void fms_switch_alert_badcrc_count(struct lf_xbar *xp, int p, int fatal);
void fms_switch_alert_updown_count(struct lf_xbar *xp, int p);
void fms_switch_alert_xbar_int_link_badcrc(struct lf_xbar *xp, int port, int fatal);
void fms_switch_alert_xbar_ext_link_badcrc(struct lf_xbar *xp, int port, int fatal);
void fms_switch_alert_xbar_host_link_badcrc(struct lf_xbar *xp, int port);
